using System;
using System.Reflection;
using System.Collections.Generic;
using System.Text;

namespace ReflectMembers
{
   class Program
   {
      static void Main(string[] args)
      {
         ReflectMethods.Customer<string> cust = new ReflectMethods.Customer<string>();
         Type t = cust.GetType();
         MemberInfo[] members = t.GetMembers(BindingFlags.NonPublic | BindingFlags.Public |
            BindingFlags.GetProperty | BindingFlags.SetProperty | BindingFlags.Instance);
         foreach (MemberInfo member in members)
         {
            Console.WriteLine("{0} ({1})", member.Name, member.MemberType.ToString());
            if (member.MemberType == MemberTypes.Property)
            {
               Console.WriteLine("\t Waciwo");
               PropertyInfo pi = t.GetProperty(member.Name);
               Console.WriteLine("\t\tTyp danych: {0}", pi.PropertyType.ToString());
               Console.WriteLine("\t\tBieca warto: {0}", pi.GetValue(cust, null));
            }
            if (member.MemberType == MemberTypes.Field)
            {
               Console.WriteLine("\t Pole");
               FieldInfo fi = t.GetField(member.Name,
                  BindingFlags.NonPublic | BindingFlags.Public | BindingFlags.Instance);
               Console.WriteLine("\t\tTyp danych: {0}", fi.FieldType.ToString());
               Console.WriteLine("\t\tBieca warto: {0}", fi.GetValue(cust));
            }
         }

         Console.ReadLine();

      }
   }
}
